SET SQL_SAFE_UPDATES = 0;

SET @applicantSendOffer=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');

	UPDATE `sql_dtprovider` SET `sqlQuery`="select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE,group_concat(DEVICE_ID) AS DEVICE_ID,LOGO_URL,ACADEMY_LOCATION_ID,ACADEMY_ID,LOCATION_ID from
(
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as LAST_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
		WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL,
        f.deviceTokenId AS DEVICE_ID,
		al.id AS ACADEMY_LOCATION_ID,
        al.academyId AS ACADEMY_ID,
        al.locationId AS LOCATION_ID
	from 
		students s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
        LEFT JOIN fire_base_persons_info f ON f.userId = s.userId
		LEFT JOIN admission adm ON adm.studentId = s.userId AND adm.activeStatus = TRUE
		LEFT JOIN academy_location al ON al.id = adm.academyLocationId
		INNER JOIN program_batch_students pbs ON pbs.admissionId = adm.id  and pbs.isCurrentPeriod = true and pbs.exitDate is null
		LEFT JOIN organizations org ON org.id = 1
	UNION
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as MIDDLE_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
		(CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
		WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL,
        f.deviceTokenId AS DEVICE_ID,
        al.id AS ACADEMY_LOCATION_ID,
        al.academyId AS ACADEMY_ID,
        al.locationId AS LOCATION_ID
	from 
		staffs s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
		LEFT JOIN fire_base_persons_info f ON f.userId = u.id
        LEFT JOIN user_academy_locations ual ON ual.userId = u.id AND ual.whetherPrimary = TRUE 
	LEFT JOIN academy_location al ON al.id = ual.academyLocationId
	LEFT JOIN organizations org ON org.id = 1
) as PSEUDO
 where date_format(BIRTH_DATE,'%m-%d') = date_format(now(),'%m-%d')
and id in (namedParams) group by id",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "id",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 8
        },
         {
            "id": 10,
            "value": "locationId",
            "resultKey": "LOCATION_ID",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
}' WHERE `dataProviderId`=@applicantSendOffer;

SET SQL_SAFE_UPDATES = 1;